/****** Object:  StoredProcedure [dbo].[P_ATUALIZA_PRECO_TABLOIDE]    Script Date: 02/26/2014 19:52:06 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_PRECO_TABLOIDE_MELHOR_OFERTA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ATUALIZA_PRECO_TABLOIDE_MELHOR_OFERTA]
GO
GO 


--P_ATUALIZA_PRECO_TABLOIDE_MELHOR_OFERTA 1

--Procedure para atualizao de preos do tabloide
CREATE  PROCEDURE [dbo].[P_ATUALIZA_PRECO_TABLOIDE_MELHOR_OFERTA] @CD_EMP INT=1
	WITH ENCRYPTION AS  

SET NOCOUNT ON;
declare @filial int;
/*************************************************************************************************************************/
	
	CREATE TABLE #TBL_MELHOR_OFERTA (CD_EMP 		tinyINT, 		
										CD_FILIAL 		INT, 
										CD_PROD 		INT, 
										VLR_MELHOR_OFERTA MONEY );

	
	CREATE TABLE #TBL_MELHOR_OFERTA_AVISTA (CD_EMP 		tinyINT, 		
										CD_FILIAL 		INT, 
										CD_PROD 		INT,  
										VLR_MELHOR_OFERTA_AVISTA MONEY);
/*************************************************************************************************************************/
	
	Print 'Registra os produtos em mais de um tabloide Filial '  + convert(varchar(10),@filial) + ' ' + convert(varchar, getdate(),108);
	
	--Registra os produtos em mais de um tabloide
	INSERT INTO #TBL_MELHOR_OFERTA 
	SELECT     
		T.CD_EMP 
		,F.CD_FILIAL 
		,c.CD_PROD
		,MIN(c.VLR_GRP_PROD) AS VLR_OFERTA 
	FROM         
		EST_PROD_TABLOIDE  T
		INNER JOIN EST_PROD_TABLOIDE_CPL c ON 
		T.CD_EMP = c.CD_EMP AND 
		T.CD_TABLOIDE = c.CD_TABLOIDE 
		INNER JOIN EST_PROD_TABLOIDE_FILIAL F ON 
		T.CD_EMP = F.CD_EMP AND 
		T.CD_TABLOIDE = F.CD_TABLOIDE
	WHERE      
		T.CD_EMP=1	
		AND T.FLAG_VIGENCIA =1
		AND ISNULL(T.FLAG_DESCONTO_EXCLUSIVO_INTEGRACAO,0) = 0
	GROUP BY T.CD_EMP, 
		F.CD_FILIAL, 
		c.CD_PROD
	HAVING count(C.CD_EMP) >1 ;
 
	CREATE UNIQUE CLUSTERED INDEX IX_#TBL_MELHOR_OFERTA ON #TBL_MELHOR_OFERTA (CD_PROD,CD_FILIAL,CD_EMP) ;

 /*************************************************************************************************************************/
	
	Print 'Registra os produtos em mais de um tabloide Filial - a vista '  + convert(varchar(10),@filial) + ' ' + convert(varchar, getdate(),108);
	
	--Registra os produtos em mais de um tabloide
	INSERT INTO #TBL_MELHOR_OFERTA_AVISTA 
	SELECT     
		T.CD_EMP 
		,F.CD_FILIAL 
		,c.CD_PROD 
		,MIN(c.VLR_VISTA)	AS VLR_VISTA
	FROM         
		EST_PROD_TABLOIDE  T
		INNER JOIN EST_PROD_TABLOIDE_CPL c ON 
		T.CD_EMP = c.CD_EMP AND 
		T.CD_TABLOIDE = c.CD_TABLOIDE 
		INNER JOIN EST_PROD_TABLOIDE_FILIAL F ON 
		T.CD_EMP = F.CD_EMP AND 
		T.CD_TABLOIDE = F.CD_TABLOIDE
	WHERE      
		T.CD_EMP=1	
		AND T.FLAG_VIGENCIA =1
	GROUP BY T.CD_EMP, 
		F.CD_FILIAL, 
		c.CD_PROD
	HAVING count(C.CD_EMP) >1 ;
 

	CREATE UNIQUE CLUSTERED INDEX IX_#TBL_MELHOR_OFERTA_VISTA ON #TBL_MELHOR_OFERTA_AVISTA (CD_PROD,CD_FILIAL,CD_EMP) ;
/*************************************************************************************************************************/

	DELETE FROM R
	FROM 
		EST_PROD_PRECO p  with (nolock) 
		INNER JOIN 	#TBL_MELHOR_OFERTA r  ON
		P.CD_EMP     =  R.CD_EMP AND
		P.CD_FILIAL  =  R.CD_FILIAL AND
		P.CD_PROD    =  R.CD_PROD 
	WHERE
		p.VLR_OFERTA = R.VLR_MELHOR_OFERTA;


	Print 'Removeu registros sem alteracao - Time '+ convert(varchar,getdate(),108); 


	DELETE FROM R
	FROM 
		EST_PROD_PRECO p  with (nolock) 
		INNER JOIN 	#TBL_MELHOR_OFERTA_AVISTA r  ON
		P.CD_EMP     =  R.CD_EMP AND
		P.CD_FILIAL  =  R.CD_FILIAL AND
		P.CD_PROD    =  R.CD_PROD 
	WHERE
		p.VLR_OFERTA_AVISTA = R.VLR_MELHOR_OFERTA_AVISTA;
		
	Print 'Removeu registros sem alteracao - oferta a vista Time '+ convert(varchar,getdate(),108); 


/*************************************************************************************************************************/
 
	Declare cAlteraTab cursor fast_forward read_only
	for
	select distinct 
		CD_FILIAL
	from
		#TBL_MELHOR_OFERTA 
	union 
	select distinct 
		CD_FILIAL
	from
		#TBL_MELHOR_OFERTA_AVISTA
	order by cd_filial;


/*************************************************************************************************************************/

OPEN cAlteraTab
FETCH NEXT from cAlteraTab INTO @filial
	WHILE @@FETCH_STATUS=0
	  begin
		Print 'Atualizando melhor oferta -  Filial '  + convert(varchar(10),@filial) + ' ' + convert(varchar, getdate(),108);
		 
		UPDATE p
		SET
			p.VLR_OFERTA = R.VLR_MELHOR_OFERTA, 
			p.DT_CAD     = GETDATE() 
		FROM 
			EST_PROD_PRECO p
			INNER JOIN 	#TBL_MELHOR_OFERTA r  ON
			P.CD_EMP     =  R.CD_EMP AND
			P.CD_FILIAL  =  R.CD_FILIAL AND
			P.CD_PROD    =  R.CD_PROD 
		where
			p.cd_emp=@cd_emp
			AND P.CD_FILIAL=@filial;

		UPDATE p
		SET
			p.VLR_OFERTA_AVISTA = R.VLR_MELHOR_OFERTA_AVISTA, 
			p.DT_CAD     = GETDATE() 
		FROM 
			EST_PROD_PRECO p
			INNER JOIN 	#TBL_MELHOR_OFERTA_AVISTA r  ON
			P.CD_EMP     =  R.CD_EMP AND
			P.CD_FILIAL  =  R.CD_FILIAL AND
			P.CD_PROD    =  R.CD_PROD 
		where
			p.cd_emp=@cd_emp
			AND P.CD_FILIAL=@filial;
			
		FETCH NEXT from cAlteraTab  INTO @filial;
	end

	Close cAlteraTab  
	Deallocate cAlteraTab ; 
	drop table #TBL_MELHOR_OFERTA;

		 